/*
GMCOM.CPP
Copyright (C) 10/31/2002 by Greg Wittmeyer
All Rights Reserved

This source code file is compiled into GMCOM.EXE.  It is a command line
interface to the Gammadyne Mailer Email Sending Engine in GMCOM.DLL.

This variant interfaces with GMCOM.DLL via COM.
*/

#pragma warning(disable : 4121)	// alignment of a member was sensitive to packing
#pragma warning(disable : 4163)	// not available as an intrinsic function
#pragma warning(disable : 4577)	// 'noexcept' used with no exception handling
#pragma warning(disable : 4710)	// function not expanded inline

#ifdef _DEBUG
  #error No Debug!
#endif

#include <windows.h>
#include <stdio.h>


// obtain the IGMEngine object from the gmcom.dll type library
#import "c:\g\gmcom.dll" no_namespace

// this file contains the CLSID's needed by CoCreateInstance()
#include "gmcom_i.c"

char *PROJECT_ERROR = "*** Pseudo-Project Error ***";

// this is used to initialize and uninitialize the COM system
struct InitCOM
{
InitCOM()	{ CoInitialize(NULL); }
~InitCOM()	{ CoUninitialize();   }
} g_Init;


/*
Return an English description of the specified system error code.
*/
const char *scs_describe()
{
DWORD error_code = GetLastError();
if(error_code==ERROR_SUCCESS)
	return "";

static LPVOID lpMsgBuf = NULL;

// if this function was called before, free the message buffer
if(lpMsgBuf) {
	LocalFree(lpMsgBuf);
	lpMsgBuf = NULL;
	}

// get the message string
FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	NULL, error_code, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	(LPTSTR) &lpMsgBuf, 0, NULL);

return lpMsgBuf ? (const char *)lpMsgBuf : "";
}


/*
Main
*/
void __cdecl main(int argc, char **argv)
{
// parse the command line
int i;
enum { MODE_NONE, MODE_HELP, MODE_SEND_FILE } mode = MODE_NONE;
char *filepath = NULL;
bool nologo = false;	// Hide the program banner.
bool nostats = false;	// Don't report performance stats.
bool noerr = false;	// Don't report errors.
bool nosum = false;	// Don't report the operation summary (sent, failed, etc.).

for(i = 1; i < argc; i++) {
	char *arg = argv[i];

	if(strchr("/+-", *arg)) {
		// this is a switch
		arg++;

		if(!strcmp(arg, "?")) {
			mode = MODE_HELP;
			continue;
			}

		if(!_strcmpi(arg, "nologo")) {
			nologo = true;
			continue;
			}

		if(!_strcmpi(arg, "nostats")) {
			nostats = true;
			continue;
			}

		if(!_strcmpi(arg, "nosum")) {
			nosum = true;
			continue;
			}

		if(!_strcmpi(arg, "noerr")) {
			noerr = true;
			continue;
			}

		if(!_strcmpi(arg, "q")) {
			noerr = nostats = nologo = nosum = true;
			continue;
			}

		printf("Invalid command line switch: %s\r\n", arg);
		return;
		}

	// not a switch
	if(mode != MODE_NONE) {
		printf("Unexpected command line parameter: %s\r\n", arg);
		return;
		}

	mode = MODE_SEND_FILE;
	filepath = arg;
	}

// banner
if(!nologo) {
	puts("GMCOM.EXE - Gammadyne Mailer Command Line Module");
	puts("Copyright (C) 2002-2020 by Gammadyne Corporation - All Rights Reserved\r\n");
	}

// help
if(mode != MODE_SEND_FILE) {
	puts("Usage:  gmcom.exe [/noerr] [/nologo] [/nostats] [/nosum] [/q] filepath\r\n");
	puts("/noerr   Suppress output of error messages.");
	puts("/nologo  Suppress output of program banner.");
	puts("/nostats Suppress output of operation performance statistics.");
	puts("/nosum   Suppress output of operation summary.");
	puts("/q       Suppress all output.");
	puts("filepath The path and filename of the pseudo-project file.");
	return;
	}

// create the COM object
IGMEngine *ptr = NULL;
HRESULT hr = CoCreateInstance(CLSID_GMEngine, NULL, CLSCTX_INPROC_SERVER, IID_IGMEngine, (void **)&ptr);
if(hr != S_OK) {
	printf("ERROR:  failed to create the COM object, code %d (0x%x)\r\n%sReinstall Gammadyne Mailer so that the COM object is re-installed and\r\nre-registered.\r\n", hr, hr, scs_describe());
	return;
	}

// load the project settings
int success = 1;

/*
ptr->load_mem(
	"From:foo@bar.com\r\n"
	"Recipients:foo@bar.com\r\n"
	"TextBody:it works!\r\n"
	"DirectDelivery:1\r\n"
	"LogFile:c:\\killme.log\r\n"
	, &success
	);
*/

success = ptr->load_file((unsigned char *)filepath);

// this will also work:
//success = ptr->load_file_w((_bstr_t)filepath);

int status = 0;

if(!success) {
	// error in project
	if(!noerr)
		puts(PROJECT_ERROR);
} else {
	// run the send operation
	status = ptr->send_messages();

	if(!status) {
		// error in project
		if(!noerr)
			puts(PROJECT_ERROR);
		}
	}

// report any error information
if(!noerr) {
	char *error = (char *)ptr->get_error_description();
	if(error && *error) {
		puts(error);
		}
	}

// report the operation results
if(status) {
	/*
	int success_count = ptr->get_successful_sends();
	printf("Successful sends: %d\r\n", success_count);

	int failure_count = ptr->get_failed_sends();
	printf("Failed sends: %d\r\n", failure_count);
	*/

	// report the operation summary
	if(!nosum) {
		char *summary = (char *)ptr->get_summary();
		if(summary)
			puts(summary);
		}

	// report the performance stats
	if(!nostats) {
		char *stats = (char *)ptr->get_stats();
		if(stats)
			puts(stats);
		}
	}

// release the Gammadyne Mailer Engine object
ptr->Release();
}
